<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
[content_type:'text/html; charset=UTF-8']
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8" />
	<title>Examples Pack - Poll</title>
	<link rel="stylesheet" rev="stylesheet" href="../examples.css.lasso" type="text/css" />
	<?LassoScript
	// Include the library file which contains many of the tags 
	// that are utilized in these examples.
	library((string_replaceregexp: response_path, -find='(.*/).*?/', -replace='\\1') + 'library.lasso');
	// Include the library file which creates the required databases, tables and groups
	library('initialize.lasso');
	?>
	<script src="poll.js" type="text/javascript" language="javascript"></script>
	<style type="text/css">
		h2
		{ 
			text-align: center; 
		}
		.group_list
		{
			width: 99%;
			background: #FFFFFF;
			margin-bottom: 40px;
		}
		.group
		{
			width: 100%;
			background: #94ADBE;
			border: 4px solid white;
			border-bottom: 2px;
		}
		.group_title
		{
			padding: 4px;
			padding-left: 12px;
		}
		.item
		{
			background: #D0DEE8;
			margin-left: 7px;
			padding-left: 4px;
			padding-right: 4px;
			border-left: 2px solid white;
			border-top: 2px solid white;
		}
		.item_title
		{
			border-bottom: solid 1px #94ADBE;
		}
		.item_details
		{
			margin: 0px 0px 0px 12px;
			font-style: italic;
			font-size: 70%;
		}
		.item_code
		{
			margin: 0px 0px 0px 12px;
			font-size: 70%;
			width: 75%; 
			border: 1px inset white; 
			white-space: pre; 
			padding: 2px; 
			margin: 6px; 
			overflow: auto;
		}
		.sub_title
		{
			margin: 0px 0px 0px 12px;
			border-bottom: solid 1px #94ADBE;
		}
		.sub_details
		{
			margin: 0px 0px 0px 24px;
			font-style: italic;
			font-size: 70%;
		}
		th
		{
			text-align: right;
			font-weight: normal;
			vertical-align: top;
		}
		td
		{
			text-align: left;
			font-weight: normal;
			vertical-align: top;
			font-size: 70%;
		}
	</style>
</head>
<body>
	<?LassoScript
		
		// This page decides which of the solution pages to show to the site visitor
		// based on what action parameters were passed to the page.  The 'handled'
		// variable is used to determine if a valid page has been returned.  If none
		// of the solution pages sets 'handled' to true then the default solution
		// page is returned.

		var: 'handled' = false;

		// If the action parameter 'poll' contains 'new' then the 'poll_create.lasso'
		// page is shown.  This allows the visitor to create a new poll.
		//
		// If the action parameter 'poll' contains any other value then the 'poll_edit.lasso'
		// page is shown.  Note that if the value is not valid then 'handled' is not set to true.
		
		if: (action_param: 'poll');
			if: (action_param: 'poll') >> 'new';
				include: 'poll_create.lasso';
			else;
				include: 'poll_edit.lasso';
			/if;
		/if;
	
		// If an error occurred then the 'error.lasso' page is shown.
		//
		// By default the 'poll_list.lasso' page is shown.

		if: $handled == false;
			if: (error_msg != error_noerror);
				include: 'error.lasso';
			else;
				include: 'poll_list.lasso';
			/if;
		/if;
	
		// include the footer that is shared by the examples
		
		include((string_replaceregexp: response_path, -find='(.*/).*?/', -replace='\\1') + 'examples_footer.lasso');
	?>
</body>
</html>
